unit MainForm;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.Handles, SimpleEcoWebDemoEcoSpace, CoreClassesUnit;

type
  TMainForm = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnCreateTestData_Click(sender: System.Object; e: System.EventArgs);
    procedure btnNewOrder_Click(sender: System.Object; e: System.EventArgs);
  strict protected  
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    btnCreateTestData: System.Web.UI.WebControls.Button;
    btnNewOrder: System.Web.UI.WebControls.Button;
    ehAllPrducts: Borland.Eco.Handles.ExpressionHandle;
    dgAllOrders: System.Web.UI.WebControls.DataGrid;
  {$ENDREGION}
  strict private
    fEcoSpace: TSimpleEcoWebDemoEcoSpace;
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
    procedure Page_Unload(sender: System.Object; e: System.EventArgs);
  strict protected
    procedure OnInit(e: EventArgs); override;
    function get_EcoSpace: TSimpleEcoWebDemoEcoSpace;
    procedure DoneWithEcoSpace;
    property EcoSpace: TSimpleEcoWebDemoEcoSpace read get_EcoSpace;
  public
    procedure DataBind; override;
  strict protected
  {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObject;
  {$ENDREGION}
  {$REGION 'DataGrid Events'}
  procedure DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  procedure DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  procedure DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  procedure DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TMainForm.InitializeComponent;
type
  TArrayOfBorland_Eco_Handles_AbstractColumn = array of Borland.Eco.Handles.AbstractColumn;
var
  OclColumn11: Borland.Eco.Handles.OclColumn;
begin
  OclColumn11 := Borland.Eco.Handles.OclColumn.Create;
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.ehAllPrducts := Borland.Eco.Handles.ExpressionHandle.Create;
  Include(Self.dgAllOrders.CancelCommand, Self.DataGrid_CancelCommand);
  Include(Self.dgAllOrders.EditCommand, Self.DataGrid_EditCommand);
  Include(Self.dgAllOrders.UpdateCommand, Self.DataGrid_UpdateCommand);
  Include(Self.dgAllOrders.DeleteCommand, Self.DataGrid_DeleteCommand);
  Include(Self.btnCreateTestData.Click, Self.btnCreateTestData_Click);
  Include(Self.btnNewOrder.Click, Self.btnNewOrder_Click);
  // 
  // rhRoot
  // 
  Self.rhRoot.EcoSpaceType := TypeOf(SimpleEcoWebDemoEcoSpace.TSimpleEcoWebDemoEcoSpace);
  // 
  // ehAllPrducts
  // 
  Self.ehAllPrducts.AddExternalId := True;
  OclColumn11.Expression := 'self.OrderItem->collect(Price*Quantity)->sum';
  OclColumn11.Name := 'OrderTotal';
  Self.ehAllPrducts.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(OclColumn11));
  Self.ehAllPrducts.Expression := 'Order.allInstances';
  Self.ehAllPrducts.RootHandle := Self.rhRoot;
  Include(Self.Unload, Self.Page_Unload);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TMainForm.Page_Load(sender: System.Object; e: System.EventArgs);
var
  Id: string;
begin
  EcoSpace.Active := True;
  Id := Request.Params['RootId'];
  if Assigned(Id) and (Id <> '') then
    rhRoot.SetElement(ObjectForId(Id));
	if not IsPostBack then
    DataBind;
  // TODO: Put user code to initialize the page here
end;

procedure TMainForm.Page_Unload(sender: System.Object; e: System.EventArgs);
begin
	DoneWithEcoSpace();
end;

procedure TMainForm.DataBind;
begin
	ElementHandle.EnsureAllBindingLists;
  inherited DataBind;
end;

{$REGION 'Utility Methods'}
procedure TMainForm.UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function TMainForm.IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function TMainForm.ObjectForId(Id: string): IObject;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

{$ENDREGION}

{$REGION 'DataGrid Events'}

// The following code is useful if the form contains a System.Web.UI.Datagrid;
// It assumes that the elementhandle acting as a datasource has
// AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"

procedure TMainForm.DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  ToDelete: IObject;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  ToDelete := ObjectForId(Id);
	if Assigned(ToDelete) then
    ToDelete.Delete;
  UpdateDatabase;
  DataBind;
end;

procedure TMainForm.DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := e.Item.ItemIndex;
  DataBind;
end;

procedure TMainForm.DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  Row: TObject;
  Eh: ElementHandle;
  ColIndex: Integer;
  Col: BoundColumn;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  SourceGrid.DataBind(); // To set DataSource
  Eh := SourceGrid.DataSource as ElementHandle;
  Row := eh.RenderElement(ObjectForId(Id));
  for colIndex := 0 to SourceGrid.Columns.Count-1 do
  begin
    Col := BoundColumn(SourceGrid.Columns[colIndex]);
    if Assigned(Col) and (not Col.ReadOnly) then
      eh.SetRenderedElementProperty(row, Col.DataField, (e.Item.Cells[colIndex].Controls[0] as TextBox).Text, true);
  end;
	UpdateDatabase;
	SourceGrid.EditItemIndex := -1;
	DataBind;
end;

procedure TMainForm.DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := -1;
  DataBind;
end;

procedure TMainForm.btnNewOrder_Click(sender: System.Object; e: System.EventArgs);
var
  AOrder: Order;
begin
  AOrder := Order.Create(EcoSpace);
  AOrder.Customer := 'New Customer';
  UpdateDatabase();
  Response.Redirect(System.String.Format('OrderForm.aspx?RootId={0}', IdForObject(AOrder.AsIObject())));
end;

procedure TMainForm.btnCreateTestData_Click(sender: System.Object; e: System.EventArgs);
var
  AOrder: Order;
	Item:	OrderItem;
begin

  AOrder := Order.Create(EcoSpace);
  AOrder.Customer := 'Eco Group';
  AOrder.ShippingAddress := '100 Eco road';
  Item := OrderItem.Create(EcoSpace);
  Item.Order := AOrder;
  Item.Product := 'PaperClip';
  Item.Quantity := 10000;
  Item.Price := 0.01;

  Item := OrderItem.Create(EcoSpace);
  Item.Order := AOrder;
  Item.Product := 'Saab 9.3 Turbo';
  Item.Quantity := 1;
  Item.Price := 20000;

  Item := OrderItem.Create(EcoSpace);
  Item.Order := AOrder;
  Item.Product := 'Big Mac';
  Item.Quantity := 5;
  Item.Price := 2;

  AOrder := Order.Create(EcoSpace);
  AOrder.Customer := 'Compiler Group';
  AOrder.ShippingAddress := '50 Drive way';
  item := OrderItem.Create(EcoSpace);
  item.Order := AOrder;
  item.Product := 'Jolt Cola';
  item.Quantity := 100;
  item.Price := 0.59;

  item := OrderItem.Create(EcoSpace);
  item.Order := AOrder;
  item.Product := 'Dell Latitude';
  item.Quantity := 1;
  item.Price := 1243;

  item := OrderItem.Create(EcoSpace);
  item.Order := AOrder;
  item.Product := 'TP cable';
  item.Quantity := 5;
  item.Price := 1.15;

  UpdateDatabase();
  DataBind();
end;
{$ENDREGION}

procedure TMainForm.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function TMainForm.get_EcoSpace: TSimpleEcoWebDemoEcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fecoSpace := TEcoSpaceProvider.GetEcoSpace;
		rhRoot.EcoSpace := fEcoSpace;
		// Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure TMainForm.DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or it's contents here.
	// Otherwise it is not safe to return it to a pool.

  TEcoSpaceProvider.ReturnEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

end.

